<?php
error_reporting(0);
ini_set('display_errors', 0);

/*
 * 🔒 @ Atualização de Credenciais 
 * 🚀 @ Versão: 1.0.2
 * 📅 @ Atualizado: <?= date('d/m/Y') ?>
 */

include "includes/header.php";
$table_name = "users";
$res = $db->select($table_name, "*", "", "");

if (isset($_POST["submit"])) {
    unset($_POST["submit"]);

    // Validação básica
    if (empty($_POST["username"]) || empty($_POST["password"])) {
        echo '<div class="alert alert-danger">⚠️ Por favor, preencha todos os campos!</div>';
    } else {
        $updateData = $_POST;
        $db->update($table_name, $updateData, "id = :id", [":id" => 1]);
        session_regenerate_id();
        $_SESSION["loggedin"] = true;
        $_SESSION["name"] = $_POST["username"];

        echo '<script>
            Swal.fire({
                icon: "success",
                title: "✅ Credenciais Atualizadas!",
                text: "Suas credenciais foram atualizadas com sucesso!",
                showConfirmButton: false,
                timer: 2000
            }).then(() => {
                window.location.href = "' . basename($_SERVER["SCRIPT_NAME"]) . '?status=1";
            });
        </script>';
    }
}
?>

<style>
    .credentials-card {
        border-radius: 15px;
        box-shadow: 0 6px 20px rgba(0,0,0,0.15);
        border: none;
    }

    .card-header-warning {
        background: linear-gradient(135deg, #ff9a9e 0%, #fad0c4 100%);
        border-radius: 15px 15px 0 0 !important;
    }

    .form-label {
        font-weight: 600;
        color: #495057;
    }

    .form-control {
        border-radius: 8px;
        padding: 12px 15px;
        border: 2px solid #e0e0e0;
        transition: all 0.3s;
    }

    .form-control:focus {
        border-color: #4a6baf;
        box-shadow: 0 0 0 3px rgba(74, 107, 175, 0.2);
    }

    .btn-update {
        background: linear-gradient(135deg, #4a6baf 0%, #2c3e50 100%);
        border: none;
        border-radius: 30px;
        padding: 12px 30px;
        font-weight: 600;
        letter-spacing: 0.5px;
        transition: all 0.3s;
    }

    .btn-update:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 15px rgba(74, 107, 175, 0.4);
    }
</style>

<div class="col-md-6 mx-auto">
    <div class="card-body">
        <div class="card credentials-card">
            <div class="card-header card-header-warning text-white">
                <center>
                    <h2><i class="fas fa-user-shield"></i> 🔒 Matenha o admin como nome de usuário ou senha</h2>
                </center>
            </div>

            <div class="card-body">
                <form method="post">
                    <div class="form-group">
                        <div class="form-group form-float form-group-lg">
                            <div class="form-line">
                                <label class="form-label"><i class="fas fa-user"></i> Nome de Usuário</label>
                                <input type="text" class="form-control" name="username" value="<?= htmlspecialchars($res[0]["username"]) ?>" placeholder="Digite um nome de usuário seguro" required>
                            </div>
                        </div>
                    </div>

                    <div class="form-group mt-4">
                        <div class="form-group form-float form-group-lg">
                            <div class="form-line">
                                <label class="form-label"><i class="fas fa-lock"></i> Senha</label>
                                <input type="password" class="form-control" name="password" value="<?= htmlspecialchars($res[0]["password"]) ?>" placeholder="Digite uma senha segura" required>
                                <small class="form-text text-muted">Recomendamos usar letras, números e caracteres especiais</small>
                            </div>
                        </div>
                    </div>

                    <hr class="my-4">

                    <center>
                        <button type="submit" name="submit" class="btn btn-update text-white">
                            <i class="fas fa-save"></i> 💾 Atualizar Credenciais
                        </button>
                    </center>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include "includes/footer.php"; ?>
</body>
</html>
