<?php
include "includes/functions.php";
if (session_status() === PHP_SESSION_NONE) session_start();

function showSuccessAndRedirect($url) {
    echo '<!DOCTYPE html><html lang="pt-BR"><head><meta charset="UTF-8"><title>Redirecionando...</title><meta name="viewport" content="width=device-width, initial-scale=1.0"><style>body{margin:0;padding:0;background:#1e1b2e;color:#00e676;font-family:\'Roboto\',sans-serif;display:flex;justify-content:center;align-items:center;height:100vh}.message{text-align:center;font-size:1.5rem;font-weight:600;background:#2a2640;padding:30px 40px;border-radius:16px;box-shadow:0 10px 25px rgba(0,0,0,0.4)}</style><script>setTimeout(()=>{window.location.href="' . $url . '"},2000);</script></head><body><div class="message">✅ Logado com sucesso.<br>Redirecionando...</div></body></html>';
    exit;
}

if (!empty($_SESSION["name"])) {
    showSuccessAndRedirect($_SESSION["name"] === "admin" ? "user.php" : "dash.php");
}

$db->insertIfEmpty("users", ["id" => "1", "username" => "admin", "password" => "admin"]);

$login_error = "";
if (isset($_POST["login"])) {
    $username = trim($_POST["username"]);
    $password = $_POST["password"];

    $userData = $db->select("users", "*", "username = :username", "", [":username" => $username]);
    if ($userData && $password === $userData[0]["password"]) {
        session_regenerate_id();
        $_SESSION["loggedin"] = true;
        $_SESSION["name"] = $username;
        showSuccessAndRedirect($username === "admin" ? "user.php" : "dash.php");
    } else {
        $login_error = $userData ? "Senha incorreta!" : "Usuário não encontrado!";
    }
    $db->close();
}

$json_data = file_get_contents('./codigo_json.json');
$data = $json_data ? json_decode($json_data, true) : [];
$codigo = $data['codigo'] ?? null;
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="utf-8">
    <title>IBO XFAST</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Performance otimizada -->
    <link rel="preconnect" href="https://fonts.googleapis.com" crossorigin>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="dns-prefetch" href="https://fonts.googleapis.com">
    <link rel="dns-prefetch" href="https://fonts.gstatic.com">
    <link rel="preload" as="style" href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">

    <style>
        :root {
            --md-bg: #1e1b2e; --md-surface: #2a2640; --md-primary: #00e676;
            --md-on-primary: #1e1b2e; --md-outline: #3b3754;
            --md-error: #ff5252; --md-text: #e0e0e0; --md-text-muted: #a0a0a0;
        }
        * { box-sizing: border-box }
        body {
            font-family: 'Roboto', sans-serif;
            margin: 0; padding: 0;
            background: var(--md-bg); color: var(--md-text);
            display: flex; justify-content: center; align-items: center;
            min-height: 100vh;
        }
        .login-container {
            display: flex; flex-direction: column;
            max-width: 900px; width: 100%;
            padding: 20px;
        }
        .left-section {
            text-align: center;
            padding: 20px;
        }
        .left-section h1 {
            font-size: 2rem;
            font-weight: 600;
        }
        .astronaut-img {
            max-width: 80%;
            height: auto;
            margin-top: 20px;
            border-radius: 12px;
        }
        .right-section {
            background: var(--md-surface);
            padding: 30px;
            border-radius: 16px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.25);
            margin-top: 20px;
        }
        .right-section h2 {
            color: var(--md-primary);
            margin-bottom: 24px;
            text-align: center;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 8px;
            font-size: 0.9rem;
        }
        .form-control {
            width: 100%;
            padding: 12px 14px;
            background: #352e50;
            border: 1px solid var(--md-outline);
            border-radius: 8px;
            color: var(--md-text);
            font-size: 1rem;
        }
        .form-control:focus {
            border-color: var(--md-primary);
            outline: none;
            box-shadow: 0 0 0 3px rgba(0, 230, 118, 0.2);
        }
        .btn-login {
            width: 100%;
            padding: 12px;
            border: none;
            border-radius: 100px;
            background: var(--md-primary);
            color: var(--md-on-primary);
            font-weight: bold;
            cursor: pointer;
        }
        .btn-login:hover {
            background: #00c853;
            transform: translateY(-2px);
        }
        .error-message {
            background: rgba(255, 82, 82, 0.1);
            color: var(--md-error);
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            text-align: center;
        }
        @media (min-width: 768px) {
            .login-container {
                flex-direction: row;
                padding: 40px;
            }
            .left-section {
                flex: 1;
                padding-right: 40px;
            }
            .right-section {
                flex: 0.7;
                margin-top: 0;
            }
        }
    </style>
</head>
<body>
<div class="login-container">
    <div class="left-section">
        <h1>Faça login para entrar para o nosso time</h1>
        <img src="./img/logo.png" alt="Gato Astronauta" class="astronaut-img" loading="lazy">
    </div>

    <div class="right-section">
        <h2>LOGIN</h2>
        <?php if (!empty($login_error)): ?>
            <div class="error-message"><?= htmlspecialchars($login_error) ?></div>
        <?php endif; ?>
        <form method="post">
            <div class="form-group">
                <label for="username">Usuário</label>
                <input type="text" id="username" name="username" class="form-control" required autofocus>
            </div>
            <div class="form-group">
                <label for="password">Senha</label>
                <input type="password" id="password" name="password" class="form-control" required>
            </div>
            <input type="submit" class="btn-login" value="LOGIN" name="login">
        </form>
    </div>
</div>
</body>
</html>
