<?php
// processar_mensagem.php

// Conectar ao banco de dados SQLite
$db = new SQLite3('permissoes.db');

// Criar a tabela mensagens se ela não existir
$db->exec(" 
    CREATE TABLE IF NOT EXISTS mensagens (
        id INTEGER PRIMARY KEY,
        filmes TEXT NOT NULL,
        series TEXT NOT NULL,
        canais TEXT NOT NULL
    )
");

// Verificar se a requisição é POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Recebe os dados em formato JSON
    $data = json_decode(file_get_contents("php://input"));

    // Verificar se os dados foram passados corretamente
    if (isset($data->tipo_mensagem) && isset($data->mensagem)) {
        $tipo_mensagem = $data->tipo_mensagem;
        $mensagem = $data->mensagem;

        // Preparar a consulta para verificar se existe um registro com id = 1
        $stmt = $db->prepare("SELECT id FROM mensagens WHERE id = 1");
        $result = $stmt->execute();

        // Verificar qual tipo de mensagem e atualizar o campo correspondente
        if ($result->fetchArray()) {
            if ($tipo_mensagem === 'Filmes') {
                $stmt = $db->prepare("UPDATE mensagens SET filmes = :mensagem WHERE id = 1");
            } elseif ($tipo_mensagem === 'Séries') {
                $stmt = $db->prepare("UPDATE mensagens SET series = :mensagem WHERE id = 1");
            } elseif ($tipo_mensagem === 'Canais') {
                $stmt = $db->prepare("UPDATE mensagens SET canais = :mensagem WHERE id = 1");
            }

            $stmt->bindValue(':mensagem', $mensagem, SQLITE3_TEXT);
            $stmt->execute();
        } else {
            // Caso contrário, faz um INSERT
            if ($tipo_mensagem === 'Filmes') {
                $stmt = $db->prepare("INSERT INTO mensagens (id, filmes, series, canais) VALUES (1, :mensagem, '', '')");
            } elseif ($tipo_mensagem === 'Séries') {
                $stmt = $db->prepare("INSERT INTO mensagens (id, filmes, series, canais) VALUES (1, '', :mensagem, '')");
            } elseif ($tipo_mensagem === 'Canais') {
                $stmt = $db->prepare("INSERT INTO mensagens (id, filmes, series, canais) VALUES (1, '', '', :mensagem)");
            }

            $stmt->bindValue(':mensagem', $mensagem, SQLITE3_TEXT);
            $stmt->execute();
        }

        // Resposta de sucesso
        echo json_encode([
            'mensagem' => 'Mensagem atualizada com sucesso!',
            'tipo_mensagem' => $tipo_mensagem,
            'mensagem' => $mensagem
        ]);
    } else {
        echo json_encode([
            'erro' => 'Dados inválidos. Tipo de mensagem e mensagem são obrigatórios.'
        ]);
    }
} else {
    echo json_encode([
        'erro' => 'Método de requisição inválido. Use POST.'
    ]);
}

// Fechar a conexão com o banco
$db->close();
?>
