<?php
include "includes/header.php";

// Caminho do arquivo JSON
$jsonPath = 'img/api01.json';

// Função para carregar e decodificar JSON
function loadJson($path) {
    if (file_exists($path)) {
        $jsonData = file_get_contents($path);
        return json_decode($jsonData, true);
    }
    return null;
}

// Carregar o JSON
$dataArray = loadJson($jsonPath);

if (!$dataArray || !isset($dataArray['data'][0])) {
    echo "Erro: JSON inválido ou não encontrado.";
    exit;
}

// Obter o nome atual do JSON
$name = $dataArray['data'][0]['name'] ?? '';

// Se o formulário for enviado, atualizar o nome no JSON
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $newName = trim($_POST['name']);

    if (!empty($newName)) {
        $dataArray['data'][0]['name'] = $newName;

        // Salvar as alterações no arquivo JSON
        if (file_put_contents($jsonPath, json_encode($dataArray, JSON_PRETTY_PRINT))) {
            echo "<script>alert('Nome atualizado com sucesso!'); window.location.href='nomeapk.php';</script>";
            exit;
        } else {
            echo "<script>alert('Erro ao salvar as alterações.');</script>";
        }
    } else {
        echo "<script>alert('O campo nome não pode estar vazio.');</script>";
    }
}
?>

<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-12 col-md-8 col-lg-6">
            <h1 class="text-center mb-4">Editar Nome</h1>

            <!-- Formulário de edição -->
            <form method="post" class="shadow p-4 rounded bg-light">
                <div class="form-group mb-3">
                    <label for="name" class="form-label">Nome:</label>
                    <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($name); ?>" class="form-control" placeholder="Digite o nome" />
                </div>
                <div class="text-center">
                    <button type="submit" class="btn btn-primary w-100">Salvar Alterações</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include "includes/footer.php"; ?>
