<?php
include 'includes/header.php';

// Caminho do arquivo JSON
$config_file = './api/config.json';

// Lê o conteúdo do arquivo JSON
$config_data = json_decode(file_get_contents($config_file), true);

// Verifica se o arquivo JSON foi lido corretamente
if ($config_data === null) {
    echo "Erro ao ler o arquivo de configuração.";
    exit;
}

// Variáveis para os dados do JSON
$dns_url = $config_data['dns_url'];
$bot_url = $config_data['bot_url'];
$bot_status = isset($config_data['bot_status']) ? $config_data['bot_status'] : 0; // Se não houver, assume inativo

// Se o formulário for enviado, atualiza o arquivo JSON com os novos valores
if (isset($_POST["submit"])) {
    // Verifica o status do bot e modifica a URL do bot de acordo com a opção selecionada
    if ($_POST["bot_status"] == 1) {
        // Status "Ativo", remove o "0" da URL
        $bot_url = preg_replace('/^0/', '', $_POST["bot_url"]);
    } else {
        // Status "Inativo", adiciona o "0" na frente da URL
        $bot_url = '0' . $_POST["bot_url"];
    }

    // Atualiza os dados do JSON com os valores do formulário
    $config_data['dns_url'] = $_POST["dns_url"];
    $config_data['bot_url'] = $bot_url; // Atualiza o URL do bot
    $config_data['bot_status'] = $_POST["bot_status"]; // Atualiza o status

    // Grava os novos dados de volta no arquivo JSON
    file_put_contents($config_file, json_encode($config_data, JSON_PRETTY_PRINT));

    echo "<script>window.location.href = 'chatbot.php?r=atualizado';</script>"; // Redireciona para evitar múltiplos submits
    exit;
}

?>

<!-- Layout da página -->
<div class="container-fluid">
    <?php if (isset($_GET['r'])): ?>
        <?php $result = $_GET['r']; ?>
        <?php switch ($result):
            case "atualizado": ?>
                <script>
                    const Toast = Swal.mixin({
                        toast: true,
                        position: 'bottom',
                        showConfirmButton: false,
                        timer: 2000,
                    });
                    Toast.fire({
                        icon: 'success',
                        title: 'Configuração Atualizada com Sucesso!'
                    });
                </script>
                <?php break; ?>
        <?php endswitch; ?>
    <?php endif; ?>

    <h1 class="h3 mb-1 text-gray-800">Configuração do ChatBot</h1>

    <!-- Content Row -->
    <div class="row">
        <div class="col-lg-12">
            <div class="shadow h-100 card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary"><i class="fa fa-cogs"></i> Configurações</h6>
                </div>
                <div class="card-body">
                    <form method="post">
                        <div class="form-group mb-4">
                            <label for="url"><strong>Status Atual: <b style="color: green;"><?php echo $bot_status == 1 ? "Ativo" : "Inativo"; ?></b></strong></label>
                            <select name="bot_status" class="form-select">
                                <option value="1" <?php echo $bot_status == 1 ? "selected" : ""; ?>>Ativo</option>
                                <option value="0" <?php echo $bot_status == 0 ? "selected" : ""; ?>>Inativo</option>
                            </select>
                        </div>
                        <div class="form-group mb-4">
                            <label class="control-label"><strong>Link do Chatbot</strong></label>
                            <div class="input-group">
                                <input type="text" class="form-control" name="bot_url" value="<?php echo $bot_url; ?>" placeholder="Link do Chatbot">
                            </div>
                        </div>
                        <div class="form-group mb-4">
                            <label class="control-label"><strong>DNS do Servidor</strong></label>
                            <div class="input-group">
                                <input type="text" class="form-control" name="dns_url" value="<?php echo $dns_url; ?>" placeholder="DNS do Servidor">
                            </div>
                        </div>
                        <button type="submit" name="submit" class="btn btn-primary"><i class="bx bx-check mr-1"></i>Salvar</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
