<?php
// Conectar ao banco de dados SQLite
$db = new SQLite3('permissoes.db');

// Obter o mac_address da requisição (via GET ou POST)
$mac_address = isset($_GET['mac_address']) ? $_GET['mac_address'] : null;

// Verificar se o mac_address foi passado
if ($mac_address) {
    // Preparar a consulta para buscar as permissões para o mac_address
    $stmt = $db->prepare("SELECT permissao FROM permissoes WHERE mac_address = :mac_address");
    $stmt->bindValue(':mac_address', $mac_address, SQLITE3_TEXT);
    $result = $stmt->execute();

    // Verificar se a consulta retornou algum dado
    $data = $result->fetchArray(SQLITE3_ASSOC);

    if ($data) {
        // Transformar a string de permissões em um array, separando por vírgulas
        $permissoes = explode(',', $data['permissao']);
        
        // Retornar as permissões formatadas como "sim" ou "não"
        echo json_encode([
            'status' => 'sucesso',
            'dados' => [
                'permissao_filmes' => in_array('Filmes', $permissoes) ? 'sim' : 'não',
                'permissao_canais' => in_array('Canais', $permissoes) ? 'sim' : 'não',
                'permissao_series' => in_array('Séries', $permissoes) ? 'sim' : 'não',
            ]
        ]);
    } else {
        // Caso o MAC não seja encontrado, retornar todas as permissões como "sim"
        echo json_encode([
            'status' => 'sucesso',
            'dados' => [
                'permissao_filmes' => 'sim',
                'permissao_canais' => 'sim',
                'permissao_series' => 'sim',
            ]
        ]);
    }
} else {
    echo json_encode([
        'status' => 'erro',
        'mensagem' => 'MAC address não fornecido'
    ]);
}

// Fechar a conexão com o banco
$db->close();
?>
