<?php 

header("Cache-Control: no-cache, no-store, must-revalidate"); // HTTP 1.1.
header("Pragma: no-cache"); // HTTP 1.0.
header("Expires: 0"); // Proxies.
include ('includes/header.php');

// Função para fazer o upload do arquivo e sobrescrever imagens mantendo o mesmo nome
function uploadFile($file, $fixedFileName) {
    if ($file["size"] == 0) {
        // Nenhum arquivo selecionado, retornar null
        return null;
    }

    $targetDir = "img/";  // Pasta de destino
    $targetFile = $targetDir . $fixedFileName;  // Nome fixo para o arquivo

    $uploadOk = 1;
    $imageFileType = strtolower(pathinfo($file["name"], PATHINFO_EXTENSION));

    // Permitir apenas alguns formatos de arquivo
    if ($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" && $imageFileType != "gif") {
        echo "Desculpe, apenas arquivos JPG, JPEG, PNG e GIF são permitidos.";
        $uploadOk = 0;
    }

    // Se tudo estiver ok, tenta fazer o upload do arquivo
    if ($uploadOk == 0) {
        echo "Desculpe, seu arquivo não foi enviado.";
    } else {
        if (move_uploaded_file($file["tmp_name"], $targetFile)) {
            return $targetFile;  // Retorna o caminho do arquivo salvo
        } else {
            echo "Desculpe, ocorreu um erro ao fazer o upload do arquivo.";
            return null;
        }
    }
}

// Atualizar o banner
if (isset($_POST['submit'])) {
    $filePaths = [];

    // Definir os nomes fixos para as imagens
    $imageFiles = [
        "iconMovie" => "Movie.png",
        "iconSeries" => "Series.jpg",
        "iconlive" => "Live.jpg"
    ];

    // Processar os uploads para as 3 imagens, mantendo os nomes fixos
    foreach ($imageFiles as $imageField => $fixedFileName) {
        if (!empty($_FILES[$imageField]["name"])) {
            $filePaths[$imageField] = uploadFile($_FILES[$imageField], $fixedFileName);
        }
    }

    // Se pelo menos uma imagem foi carregada, vamos atualizar
    if (!empty($filePaths)) {
        // Atualizar imagens no JSON mantendo o formato
        $jsonPath = 'img/api01.json';
        $jsonData = json_decode(file_get_contents($jsonPath), true);

        foreach ($filePaths as $field => $filePath) {
            if ($filePath) {
                // Substituir as imagens no JSON com o novo caminho
                $jsonData['data'][0][$field] = basename($filePath); // Apenas o nome da imagem
            }
        }

        // Salvar o JSON atualizado
        file_put_contents($jsonPath, json_encode($jsonData, JSON_PRETTY_PRINT));

        echo "<script>alert('Imagens atualizadas com sucesso!'); window.location.href='icones.php';</script>";
        exit;
    } else {
        echo "Nenhuma imagem foi enviada.";
    }
}

?>

<!-- Formulário de upload -->
<div class="col-md-8 mx-auto">
    <center>
        <h2 class="colorboard">ATUALIZAR </h2>
    </center>
    <div class="card bg-primary">
        <div class="card-body">
            <form method="post" enctype="multipart/form-data">
                <div class="form-group">
                    <label>Imagem para Filme</label>
                    <input type="file" name="iconMovie" id="iconMovie" class="form-control">
                    <img id="previewMovie" src="img/Movie.png" alt="Pré-visualização" width="100">
                </div>
                <div class="form-group">
                    <label>Imagem para Série</label>
                    <input type="file" name="iconSeries" id="iconSeries" class="form-control">
                    <img id="previewSeries" src="img/Series.jpg" alt="Pré-visualização" width="100">
                </div>
                <div class="form-group">
                    <label>Imagem para Live</label>
                    <input type="file" name="iconlive" id="iconlive" class="form-control">
                    <img id="previewLive" src="img/Live.jpg" alt="Pré-visualização" width="100">
                </div>
                <div class="col-12">
                    <button type="submit" name="submit" class="btn btn-info">SALVAR</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Função para mostrar a pré-visualização da imagem
function previewImage(input, previewId) {
    var file = input.files[0];
    if (file) {
        var reader = new FileReader();
        reader.onload = function(e) {
            document.getElementById(previewId).src = e.target.result;
        };
        reader.readAsDataURL(file);
    }
}

// Adiciona evento para os inputs de arquivo
document.getElementById("iconMovie").addEventListener("change", function() {
    previewImage(this, "previewMovie");
});

document.getElementById("iconSeries").addEventListener("change", function() {
    previewImage(this, "previewSeries");
});

document.getElementById("iconlive").addEventListener("change", function() {
    previewImage(this, "previewLive");
});
</script>

<?php include ('includes/footer.php'); ?>
