<?php
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

include ('includes/header.php');

function uploadFile($file) {
    if ($file["size"] == 0) return null;

    $targetDir = "img/";
    $fixedFileName = "bg.jpg";
    $targetFile = $targetDir . $fixedFileName;
    $imageFileType = strtolower(pathinfo($file["name"], PATHINFO_EXTENSION));

    if (!in_array($imageFileType, ["jpg", "jpeg", "png", "gif"])) {
        echo "Apenas arquivos JPG, JPEG, PNG e GIF são permitidos.";
        return null;
    }

    if (file_exists($targetFile)) unlink($targetFile);

    if (move_uploaded_file($file["tmp_name"], $targetFile)) {
        touch($targetFile);
        return $targetFile;
    }

    echo "Erro ao fazer upload.";
    return null;
}

function deleteFile($url) {
    if (file_exists($url)) unlink($url);
}

$table_name = "ads";
$base_file = basename($_SERVER["SCRIPT_NAME"]);
$adb4->exec("CREATE TABLE IF NOT EXISTS {$table_name}(id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, title VARCHAR(100), caminho TEXT)");

$res = $adb4->query("SELECT * FROM {$table_name}");

$rowU = null;
if (!empty($_GET['update'])) {
    $updateId = intval($_GET['update']);
    $resU = $adb4->query("SELECT * FROM {$table_name} WHERE id={$updateId}");
    $rowU = $resU->fetchArray(SQLITE3_ASSOC);
}

if (isset($_POST['submitU'])) {
    $file_path = null;
    if (!empty($_FILES["fileToUpload"]["name"])) {
        $file_path = uploadFile($_FILES["fileToUpload"]);
    }

    if (!empty($_POST['id'])) {
        $id = intval($_POST['id']);
        $title = $_POST['title'] ?? $rowU['title'] ?? '';
        $caminho = $file_path ?? $rowU['caminho'] ?? '';

        $adb4->exec("UPDATE {$table_name} SET title='{$title}', caminho='{$caminho}' WHERE id='{$id}'");
        $adb4->close();
        echo "<script>window.location.href='bg.php';</script>";
        exit;
    }
}

if (isset($_POST['submit'])) {
    $file_path = !empty($_FILES["fileToUpload"]["name"]) ? uploadFile($_FILES["fileToUpload"]) : null;
    if ($file_path !== null || isset($_POST['title'])) {
        $title = $_POST['title'] ?? "";
        $caminho = $file_path ?? "";
        $adb4->exec("INSERT INTO {$table_name}(title, caminho) VALUES('{$title}', '{$caminho}')");
        echo "<script>window.location.href='bg.php';</script>";
        exit;
    }
}

if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $deleteQuery = $adb4->query("SELECT caminho FROM {$table_name} WHERE id={$id}");
    $deleteRow = $deleteQuery->fetchArray(SQLITE3_ASSOC);
    deleteFile($deleteRow['caminho'] ?? '');
    $adb4->exec("DELETE FROM {$table_name} WHERE id={$id}");
    echo "<script>window.location.href='bg.php';</script>";
    exit;
}

$bgTimestamp = file_exists("img/bg.jpg") ? filemtime("img/bg.jpg") : time();
?>

<!-- Modal de confirmação -->
<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog">
  <div class="modal-dialog">
    <div class="modal-content" style="background-color: black;">
      <div class="modal-header">
        <h2 style="color: white;">CONFIRMAR</h2>
      </div>
      <div class="modal-body" style="color: white;">QUER MESMO DELETAR?</div>
      <div class="modal-footer">
        <button type="button" class="btn btn-primary" data-dismiss="modal">CANCELAR</button>
        <a class="btn btn-danger btn-ok" style="color:white;">DELETAR</a>
      </div>
    </div>
  </div>
</div>

<?php if (isset($_GET['create'])): ?>
<div class="col-md-8 mx-auto">
  <center><h2 class="colorboard">NOVO FUNDO</h2></center>
  <div class="card bg-primary">
    <div class="card-body">
      <form method="post" enctype="multipart/form-data">
        <div class="form-group">
          <input class="form-control" type="text" name="title">
          <label>NOME DO FUNDO</label>
        </div>
        <div class="form-group">
          <input type="file" name="fileToUpload" id="fileToUpload">
        </div>
        <div class="col-12">
          <button type="submit" name="submit" class="btn btn-info">SALVAR</button>
        </div>
      </form>
    </div>
  </div>
</div>

<?php elseif (isset($_GET['update']) && $rowU): ?>
<div class="col-md-8 mx-auto">
  <center><h2 class="colorboard">EDITAR FUNDO</h2></center>
  <div class="card bg-primary">
    <div class="card-body">
      <form method="post" enctype="multipart/form-data">
        <input type="hidden" name="id" value="<?= intval($_GET['update']) ?>">
        <div class="form-group">
          <input type="text" name="title" class="form-control" value="<?= htmlspecialchars($rowU['title']) ?>">
          <label>NOME DO FUNDO</label>
        </div>
        <div class="form-group">
          <input type="file" name="fileToUpload" id="fileToUpload">
        </div>
        <div class="col-12">
          <button type="submit" name="submitU" class="btn btn-info">SALVAR</button>
        </div>
      </form>
    </div>
  </div>
</div>

<?php else: ?>
<div class="col-md-12 mx-auto">
  <center>
    <h1 class="colorboard">FUNDO APP</h1>
    <a href="./<?= $base_file ?>?create" class="btn btn-primary">NOVO</a>
  </center>
  <div class="table-responsive mt-3">
    <table class="table table-striped table-sm">
      <thead style="color:grey!important">
        <tr>
          <th>ID</th>
          <th>NOME</th>
          <th>PRÉVIA</th>
          <th>EDITAR&nbsp;&nbsp;&nbsp;DELETAR</th>
        </tr>
      </thead>
      <tbody>
        <?php while ($row = $res->fetchArray(SQLITE3_ASSOC)): ?>
        <tr>
          <td><?= $row['id'] ?></td>
          <td><?= htmlspecialchars($row['title']) ?></td>
          <td>
            <img src="img/bg.jpg?<?= $bgTimestamp ?>" alt="Fundo" style="width:100px; height:auto;" loading="lazy">
          </td>
          <td>
            <a href="./<?= $base_file ?>?update=<?= $row['id'] ?>" class="btn btn-warning">EDITAR</a>
            <a href="#" class="btn btn-danger" data-href="./<?= $base_file ?>?delete=<?= $row['id'] ?>" data-toggle="modal" data-target="#confirm-delete">DELETAR</a>
          </td>
        </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>
<?php endif; ?>

<?php include ('includes/footer.php'); ?>
<script>
  $('#confirm-delete').on('show.bs.modal', function(e) {
    $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));
  });
</script>
</body>
</html>
